<?PHP
/*Skrypt pochodzi z ksiki "PHP. 101 praktycznych skryptw"
  autor: Marcin Lis        e-mail: 101scripts@marcinlis.com*/

function getImage($imgName, $imgType)
{
  if($imgType == IMG_JPEG){
         $img = imagecreatefromjpeg($imgName);
  }
  else if($imgType == IMG_GIF){
         $img = imagecreatefromgif($imgName);
  }
   else if($imgType == IMG_PNG){
         $img = imagecreatefrompng($imgName);
  }
  else{
         $img = null;
  }
  return $img;
}

function saveImage($img, $name, $imgType)
{
  $name = substr($name, 0, strlen($name) - 3);
  switch($imgType){
         case IMG_JPEG:
                $name .= "jpg";
                imagejpeg($img, $name);
                break;
         case IMG_GIF:
                $name .= "gif";
                imagegif($img, $name);
                break;
         case IMG_PNG:
                $name .= "png";
                imagepng($img, $name);
                break;
  }
}
function getImageType($src_img_name)
{
  $ext = substr($src_img_name, strlen($src_img_name) - 3, 3);
  $ext = strtolower($ext);
  if($ext == 'jpg'){
         return IMG_JPEG;
  }
  else if($ext == 'gif'){
         return IMG_GIF;
  }
  else if($ext == 'png'){
          return IMG_PNG;
  }
  else{
          return null;
  }
}

function convert_image($src_dir, $dest_dir, $name, $dest_img_type)
{
  if(($type = getImageType($src_dir.$name)) == null){
         echo("Nieznany format pliku!");
         return false;
  }
  if($type == $dest_img_type){
         echo("Format rdowy musi by rny od docelowego: ");
         echo("$src_dir.$name!");
         return false;
  }

  if(!($img = getImage($src_dir.$name, $type))){
         echo("Nie mog otworzy pliku: $src_dir$name");
         return false;
  }
  saveImage($img, $dest_dir.$name, $dest_img_type);
}

function convert_dir_images($src_dir, $dest_dir, $img_type)
{
  if(!($fd = opendir($src_dir))) return false;
  $array = array();
  $count = 0;
  while (($file = readdir($fd)) !== false){
         if($file != "." && $file != ".."){
                $array[$count++] = $file;
         }
  }
  if($dest_dir == "") $dest_dir = $src_dir;
  foreach($array as $key => $file){
         convert_image($src_dir, $dest_dir, $file, $img_type);
  }
  closedir($fd);

}
convert_dir_images("d:\\!\\", "", IMG_PNG);
?>
